% SETVOR - define VOR block parameters
%
% This routine can be used to create a set of standard block-
% parameters for the VOR radio-navigation model, taking into 
% account all relevant fixed geometrical data and signal
% sensitivity values, but leaving the initial position of the 
% aircraft relatively to the beacon to be set separately. 
%
% The defined VOR parameters are: the altitude of the VOR beacon,
% and the Course Datum (VOR radial).

clc
disp(' ');
disp('Define VOR block parameters');
disp('===========================');
HVOR  = input('Altitude of VOR antenna above sea level [m] (default 0): ');
if isempty(HVOR)
   HVOR = 0;
end
CD    = input('Course Datum [deg] (default 0): ');
if isempty(CD)
   CD = 0;
end

CD    = CD * pi/180;

disp(' ');
disp('<< Press key to save the results >>');
pause
clc

% Save the VOR parameters to file. The default folder for this action 
% is the DATA subdirectory, which is stored in the variable defdir. The 
% current directory is stored in the variable currentdir, which is used
% if the default directory can't be found.
% ---------------------------------------------------------------------
defdir = datadir;
currentdir = chdir;

% Go to default directory if that directory exists (if not, start
% save-routine from the current directory).
% ---------------------------------------------------------------
try
  chdir(defdir);
catch
  chdir(currentdir);
end

% Obtain path (use default filename ILS.DAT)
% ------------------------------------------
[filename,dirname] = uiputfile('vor.dat','Save VOR parameters');

% Save results to the specified file
% ----------------------------------
save([dirname,filename],'HVOR','CD');

% Return to previous directory and quit
% -------------------------------------
chdir(currentdir);
disp(' ');
disp('Ready.');
disp(' ');

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004.
%-----------------------------------------------------------------------